
#load data files
read.csv("LTRSEXP1.txt",header = TRUE,stringsAsFactors=T)->ltrsexp1
read.csv("OVEXP1rd.txt",header = TRUE,stringsAsFactors=T)->ovexp1
read.csv("OVEXP1noBiasRd.txt",header = TRUE,stringsAsFactors=T)->ovexp1bless

read.csv("LTRSEXP4.txt",header = TRUE,stringsAsFactors=T)->ltrsexp4
read.csv("OVEXP4rd.txt",header = TRUE,stringsAsFactors=T)->ovexp4

levels(ltrsexp1$src)<-c("Data","LTRS","LTRS with Bias")
levels(ovexp1$src)<-c("Data","Overlap")
levels(ovexp1bless$src)<-c("Data","Overlap without Bias")

all(ltrsexp1$V2[ltrsexp1$src=="Data"]==ovexp1$V2[ovexp1$src=="Data"])
all(ltrsexp1$V2[ltrsexp1$src=="Data"]==ovexp1bless$V2[ovexp1bless$src=="Data"])

#Experiment 1
#Figure 1

library(lattice)
ltrsexp1$src<-as.character(ltrsexp1$src)
ovexp1$src<-as.character(ovexp1$src)
ovexp1bless$src<-as.character(ovexp1bless$src)

rbind(ltrsexp1,ovexp1[ovexp1$src=="Overlap",],ovexp1bless[ovexp1bless$src=="Overlap without Bias",])->predictionsexp1

with(predictionsexp1,aggregate(V2*100,by=list(datatype=src,target=V3,length=V7),mean))->meansExp1

colors=c("black","lightgrey")

with(meansExp1,barchart(x~as.character(length)|datatype,
                        group=target,type="b",panel=function(...){panel.barchart(...); },layout=c(5,1),
                        par.strip.text=list(cex=1.3),
                        col=colors,lwd=3,cex=2.5,scales=list(tck=c(1,0), x=list(cex=1.5,labels=c("7","8")), y=list(cex=1.4,at=seq(60,75,2))),key=list(corner=c(1,0.9),
                        rectangles=list(col=colors,size=2),text=list(c("Repeat","Unique")),cex=1.2),
                        xlab=list(label="Target Length",cex=1.6,font=2),ylab=list(label="Accuracy (%)",cex=1.6,font=2)))->figexp1

plot(figexp1)

png(file="exp1fig1rd190921.png",units="in",width = 12,height = 5,res=300)

plot(figexp1)

dev.off()

#at=seq(60,75,2))

#Figure 2
#Experiment 4

levels(ltrsexp4$src)<-c("Data","LTRS")
levels(ovexp4$src)<-c("Data","Overlap")

ltrsexp4$src<-as.character(ltrsexp4$src)
ovexp4$src<-as.character(ovexp4$src)


rbind(ltrsexp4,ovexp4[ovexp4$src=="Overlap",])->predictionsexp4
table(predictionsexp4$src)


library(lattice)

with(subset(predictionsexp4,V8=="different"),aggregate(V2*100,by=list(datatype=src,target=V3,foil=V4),mean))->diffmeansExp4
#sub("substitute","substitution",diffmeansExp4$foil)->diffmeansExp4$foil
sub("wrongrep","wrong repeat",diffmeansExp4$foil)->diffmeansExp4$foil



#diffmeansExp4$datatype<-factor(diffmeansExp4$datatype$datatype,levels=c("data","model"),order=T)

#levels(diffmeansExp4$datatype)<-c("Data","LTRS","Overlap")


colors=c("black","lightgrey")
with(diffmeansExp4,barchart(x~foil|datatype,
                           group=target,type="b",panel=function(...){panel.barchart(...); },
                           par.strip.text=list(cex=1.3),
                           col=colors,lwd=3,cex=2.5,scales=list(tck=c(1,0), x=list(cex=1.4), y=list(cex=1.1)),key=list(corner=c(1,0.9),
                          rectangles=list(col=colors,size=2),text=list(c("Repeated","Unique")),cex=1.3,title="Target",cex.title=1.6),labels=c("unique","repeated"),
                           main=list(label="Different Trials",cex=1.5),xlab=list(label="Foil",cex=1.6,font=2),ylab=list(label="Accuracy (%)",cex=1.4,font=2)))->sdfixfig

plot(sdfixfig)

png(file="exp4fig2rd190921.png",units="in",width = 12,height = 5,res=300)

plot(sdfixfig)

dev.off()
